﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;


namespace Advent
{
    public partial class DemoAI7280 : Advent.Controls.DeviceCtrl
    {

        private AI7280_CO_Simulator _7280 = null;

        public DemoAI7280()
        {
            InitializeComponent();
            txt_ConnectSerial.Text = "SN120001";
        }

        protected override aiDevice GetDeviceReference()
        {
            return _7280;
        }

        private void DemoAI7280_Load(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// Called to initialize communications with the device
        /// </summary>
        protected override void Connect(string Serial)
        {
            if (Serial == null)
            {
                _7280 = AI7280_CO_Simulator.Connect();
            }
            else
            {
                _7280 = AI7280_CO_Simulator.Connect(Serial);
            }
        }

        protected override void InitializeFormFromDevice()
        {
            base.InitializeFormFromDevice();

            TelInt.SetTelInt(_7280.TelInt);
            RingingControl.SetGenerator(_7280.RingGenerator);
            ToneACtrl.SetGenerator(_7280.ToneA);
            ToneBCtrl.SetGenerator(_7280.ToneB);
            ToneCCtrl.SetGenerator(_7280.ToneC);
            ToneDCtrl.SetGenerator(_7280.ToneD);
            FSKGenCtrl.SetGenerator(_7280.FSKGenerator);
            AMCtrl.SetGenerator(_7280.AMGenerator);
            EchoCtrl.SetGenerator(_7280.EchoGenerator);
            MeterCtrl.SetMeter(_7280.Meter);
            DIOCtrl.SetDigitalIO(_7280.DigitalIO);
            RecordingCtrl.SetRecorder(_7280.ACRecording);
            DCRecordCtl.SetRecorder(_7280.DCRecording);
            DetectedCtrl.SetList(_7280.DetectedSignals);
            MeterPulseCtrl.SetGenerator(_7280.MeteringPulseGenerator);
            PatternGenCtrl.SetGenerator(_7280.PatternGenerator);
            MFCtrl.SetGenerator(_7280.MFGenerator);
            StatusCtrl.SetStatus(_7280.Status);
            NoiseCtrl.SetGenerator(_7280.NoiseGenerator);
            ExamplesCtrl.SetDevice(_7280);
            TermLevelCtrl.SetSupportObjects(_7280.ToneA, _7280.Meter, _7280.TelInt);
        }


    }
}
